<?php 

/* Jobs post type*/

function post_type_jobs() {
register_post_type(
                    'job', 
                    array( 'public' => true,
					 		'publicly_queryable' => true,
							'has_archive' => true, 
							'hierarchical' => false,
							'menu_icon' => get_stylesheet_directory_uri() . '/images/job.png',
                    		'labels'=>array(
    									'name' => _x('شغل', 'post type general name'),
    									'singular_name' => _x('شغل', 'post type singular name'),
    									'add_new' => _x('افزودن', 'Job'),
    									'add_new_item' => __('افزودن شغل'),
    									'edit_item' => __('ویرایش شغل'),
    									'new_item' => __('شغل جدید'),
    									'view_item' => __('نمایش شغل ها'),
    									'search_items' => __('جستجوی شغل ها'),
    									'not_found' =>  __('شغلی پیدا نشد'),
    									'not_found_in_trash' => __('شغلی در سطل زباله پیدا نشد'), 
    									'parent_item_colon' => ''
  										),							 
                            'show_ui' => true,
							'menu_position'=>5,
							'query_var' => true,
							'rewrite' => true,
							'rewrite' => array( 'slug' => 'item', 'with_front' => FALSE,),
							'register_meta_box_cb' => 'mytheme_add_box',
							'supports' => array(
							 			'title',
										'thumbnail',
										'custom-fields',
										'comments',
										'editor'
										)
							) 
					);
				} 
add_action('init', 'post_type_jobs');

/* Movie genre taxonomy */

function create_job_type_taxonomy() 
{
$labels = array(
	  						  'name' => _x( 'انواع شغل', 'taxonomy general name' ),
    						  'singular_name' => _x( 'نوع شغل', 'taxonomy singular name' ),
    						  'search_items' =>  __( 'جستجوی انواع شغل' ),
   							  'all_items' => __( 'همه انواع شغل' ),
    						  'parent_item' => __( 'نوع مادر شغل' ),
   					   		  'parent_item_colon' => __( 'نوع مادر شغل:' ),
   							  'edit_item' => __( 'ویرایش نوع شغل' ), 
  							  'update_item' => __( 'به روزرسانینوع شغل' ),
  							  'add_new_item' => __( 'افزودن نوع شغل جدید' ),
  							  'new_item_name' => __( 'نام نوع شغل جدید' ),
); 	
register_taxonomy('job_type',array('job'), array(
    'hierarchical' => true,
    'labels' => $labels,
      'show_ui' => 'radio',
    'query_var' => true,
    'rewrite' => array( 'slug' => 'job_type' ),
  ));
}

add_action( 'init', 'create_job_type_taxonomy', 0 );

/* ADD custom terms */

function add_job_term_fulltime() {
if(!is_term('تمام وقت', 'job_type')){
  wp_insert_term('تمام وقت', 'job_type');
}
}
add_action( 'init', 'add_job_term_fulltime' );

function add_job_term_parttime() {
if(!is_term('پاره وقت', 'job_type')){
  wp_insert_term('پاره وقت', 'job_type');
}
}
add_action( 'init', 'add_job_term_parttime' );

function add_job_term_contract() {
if(!is_term('قراردادی', 'job_type')){
  wp_insert_term('قراردادی', 'job_type');
}
}
add_action( 'init', 'add_job_term_contract' );


function add_job_term_freelance() {
if(!is_term('مفرد کار کردن', 'job_type')){
  wp_insert_term('مفرد کار کردن', 'job_type');
}
}
add_action( 'init', 'add_job_term_freelance' );

function add_job_term_internship() {
if(!is_term('دوره انترنی', 'job_type')){
  wp_insert_term('دوره انترنی', 'job_type');
}
}
add_action( 'init', 'add_job_term_internship' );

?>