$(function($){
    
    /* ================ MAIN NAVIGATION ================ */
	
    function piMainmenu(){
        $(" #nav ul ").css({
            display: "none"
        }); // Opera Fix
        $(" #nav li").hover(function(){
            $(this).find('ul:first').css({
                visibility: "visible",
                display: "none"
            }).slideDown(250);
        },function(){
            $(this).find('ul:first').css({
                visibility: "hidden"
            });
        });
    }
    
    function piSelectMenu(){
        $('#nav-responsive').on('change', function() {
            window.location = $(this).val();
        }); 
    }
	
    /* ================ CONTENT TABS ================ */
    
    (function() {
        $('.tabs').each(function(){
            var $tabLis = $(this).find('li');            
            var $tabContent = $(this).next('.tab-content-wrap').find('.tab-content');
            
            $tabContent.hide();
            $tabLis.first().addClass('active').show();
            $tabContent.first().show();
        });
        

        $('.tabs').on('click', 'li', function(e) {
            var $this = $(this);
            var parentUL = $this.parent();
            var tabContent = parentUL.next('.tab-content-wrap');

            parentUL.children().removeClass('active');
            $this.addClass('active');
                
            tabContent.find('.tab-content').hide();
            var showById = $( $this.find('a').attr('href') );
            tabContent.find(showById).fadeIn();            

            e.preventDefault();
        });                  
    })();
    
    /* ================ ACCORDION ================ */
    
    $('.accordion').on('click', '.title', function(event) {
        event.preventDefault();
        $(this).closest('.accordion').find('.active').next().slideUp('normal');
        $(this).closest('.accordion').find('.title').removeClass("active");        
        if($(this).next().is(':hidden') == true) {
            $(this).next().slideDown('normal');
            $(this).addClass("active");
        }
    });
    $('.accordion .content').hide();
    $('.accordion .active').next().slideDown('normal');

        
    $(document).ready(function(){					
        piMainmenu();
        piSelectMenu();

        /* ================ INSTAGRAM FEED ================ */
        $('.instagram-feed').socialstream({
            socialnetwork: 'flickr',
            limit: 6,
            username: 'Mrky1',
            overlay: true
        })
        
        /* ================ PLACEHOLDER PLUGIN ================ */
        $('input[placeholder], textarea[placeholder]').placeholder();
        
        /* ================ TOP BAR ANIMATION ================ */
        if(readCookie('pocketTopBarClosed') == 'true'){
            $('.top-bar').hide();
            $('.top-bar-wrapper').css({
                height: '3px'                
            });
        }
        $('.top-bar').on('click', '.close-frame', function(e){
            e.preventDefault();
            $(this).closest('.top-bar').slideUp();
            $(this).closest('.top-bar-wrapper').animate({
                height: '3px'
            });
            // setting cookie value to 14 days
            createCookie('pocketTopBarClosed', 'true', 1209600);
        });
    });
    
    /* ================ STATIC HEADER ================ */
    
    var window_y = 0;
    var header_height = $("#header").height() + 0;
    var scroll_position = parseInt(header_height + header_height/2);    	
    window_y = $(window).scrollTop();
	
    if ( (window_y > scroll_position) && !(is_touch_device()) ) 
        set_static_header();
	
    function set_static_header(){
        var window_y = $(window).scrollTop();
        if (window_y > scroll_position) {
            if (!($("#header").hasClass("static"))){
                $("#header").hide();
                if($('body').hasClass('homepage')){
                    $('#anything-slider').css("margin-top", header_height + "px");
                }else{
                    $(".page-title").eq(0).css("margin-top", header_height + "px");
                }                
                $("#header").addClass("static").css("top", '0');
                $("#header").fadeIn(500);
            }
				
        } else {
            if (($("#header").hasClass("static"))){
                $("#header").fadeOut(500, function(){
                    $("#header").removeClass("static");
                    if($('body').hasClass('homepage')){
                        $('#anything-slider').css("margin-top", "");
                    }else{
                        $(".page-title").eq(0).css("margin-top", "");
                    }  
                    
                    $("#header").fadeIn(300);
                });
            }
        }
    }
	
    $(window).scroll(function(){
        if (!(is_touch_device())) 
            set_static_header();
    });
    
});

function createCookie(name,value,days) {
    if (days) {
        var date = new Date();
        date.setTime(date.getTime()+(days*24*60*60*1000));
        var expires = "; expires="+date.toGMTString();
    }
    else var expires = "";
    document.cookie = name+"="+value+expires+"; path=/";
}

function readCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1,c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
}

function eraseCookie(name) {
    createCookie(name,"",-1);
}

/* Check if current device is touch device */

function is_touch_device() {
    return !!('ontouchstart' in window) // works on most browsers 
    || !!(window.navigator.msMaxTouchPoints); // works on ie10
};

